package CGI::TemplateHTML;

use strict;
use Carp;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK $AUTOLOAD);

require Exporter;
require DynaLoader;
require AutoLoader;

@ISA = qw(Exporter DynaLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT_OK = qw(
	
);
$VERSION = '1.4';

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.  If a constant is not found then control is passed
    # to the AUTOLOAD in AutoLoader.

    my $constname;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    my $val = constant($constname, @_ ? $_[0] : 0);
    if ($! != 0) {
	if ($! =~ /Invalid/) {
	    $AutoLoader::AUTOLOAD = $AUTOLOAD;
	    goto &AutoLoader::AUTOLOAD;
	}
	else {
		croak "Your vendor has not defined CGI::TemplateHTML macro $constname";
	}
    }
    eval "sub $AUTOLOAD { $val }";
    goto &$AUTOLOAD;
}
sub new {
        my $class = shift;
        return bless {}, $class;
}  
sub DESTROY {
  freeMem();
}  
sub setFile {
  my($self, $a) = @_;
  CGI::TemplateHTML::tplSetFile($a);
}  
sub freeMem {
  my($self) = @_;
  return(CGI::TemplateHTML::tplFreeMem());
}  
sub setVar {
  my($self,$a,$b) = @_;
  return(CGI::TemplateHTML::tplSetVar($a,$b));
}
sub dumpTableLine {
  my($self,$a) = @_;
  CGI::TemplateHTML::tplDumpTableLine($a);
}
sub print {
  my($self) = @_;
  return(CGI::TemplateHTML::tplPrint());
}  
sub page {
  my($self) = @_;
  return(CGI::TemplateHTML::tplPage());
}  

bootstrap CGI::TemplateHTML 1.4;

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

CGI::TemplateHTML 1.4 - Flate

=head1 SYNOPSIS

  use CGI::TemplateHTML;

=head1 DESCRIPTION

  see README file

=head1 AUTHOR

Fabien MENEMENLIS, nihilist@dead-inside.org

=head1 SEE ALSO

perl(1).

=cut
