/**************************************************************************
 *                                                                        *
 * Flate library (Fast Template)                                          *
 * Copyright (C) 2001 Fabien Menemenlis (nihilist@dead-inside.org)        *
 *                                                                        *
 * This library is free software; you can redistribute it and/or          *
 * modify it under the terms of the GNU Lesser General Public             *
 * License as published by the Free Software Foundation; either           *
 * version 2.1 of the License, or (at your option) any later version.     *
 *                                                                        *
 * This library is distributed in the hope that it will be useful,        *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 * Lesser General Public License for more details.                        *
 *                                                                        *
 * You should have received a copy of the GNU Lesser General Public       *
 * License along with this library; if not, write to the Free Software    *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  *
 * MA  02111-1307  USA                                                    *
 *                                                                        *
 **************************************************************************/

#ifndef _LIB_FLATE_H_
#define _LIB_FLATE_H_

typedef struct tempUnit {
  struct tempUnit *next;
  struct tempUnit *prev;
  char *data;
  char *name;
  int tdata;
  int type;
  int alloc;
}
tempUnit;

typedef struct {
  char *name;
  tempUnit *unit;
}
st_ptr;

typedef struct {
  tempUnit *UnitInit;
  st_ptr *tempVar, *tempZone, *tempTable;
  int tempnbVar, tempnbZone, tempnbTable;
  char *curzone, *curtable;
  char *tempBuf;
}
Template;

extern Template *templateSetFile(Template **tmplte, char *filename);
extern void templateSetVar(Template *tmplte, char *fld, char *val);
extern void templateDumpTableLine(Template *tmplte, char *ligne);
extern void templatePrint(Template *tmplte);
extern char *templatePage(Template *tmplte);
extern void templateFreeMem(Template *tmplte);

#endif
