/**************************************************************************
 *                                                                        *
 * Flate library 1.5.6 (Fast Template)                                    *
 * Copyright (C) 2013 Fabien Menemenlis (nihilist@dead-inside.org)        *
 *                                                                        *
 * This library is free software; you can redistribute it and/or          *
 * modify it under the terms of the GNU Lesser General Public             *
 * License as published by the Free Software Foundation; either           *
 * version 2.1 of the License, or (at your option) any later version.     *
 *                                                                        *
 * This library is distributed in the hope that it will be useful,        *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 * Lesser General Public License for more details.                        *
 *                                                                        *
 * You should have received a copy of the GNU Lesser General Public       *
 * License along with this library; if not, write to the Free Software    *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  *
 * MA  02111-1307  USA                                                    *
 *                                                                        *
 **************************************************************************/

/*
 * new version breaks compatibility with older ones as an argument is now
 * given to each function: this allows you to have multiple templates
 * simultanuously
 * possible memory leak, some free(curtable) could be missing but I couldn't
 * prove this again
 * memset() added when creating a new template (free() error)
 * Perl no longer supported
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#ifdef _USE_FETCH_
#include <sys/param.h>
#include <fetch.h>
#endif

#include "flate.h"


#define VARSZ 100 /* max size of a variable name */


enum {
    TEMP_HTML,
    TEMP_VAR,
    TEMP_BEGINTABLE,
    TEMP_ENDTABLE,
    TEMP_BEGINZONE,
    TEMP_ENDZONE,
    TEMP_BEGINGENTABLE,
    TEMP_ENDGENTABLE,
    TEMP_INCLUDEFILE
};


int tempcompare(const void *a, const void *b) {
    return(strcmp(((st_ptr *)a)->name, ((st_ptr *)b)->name));
}


int tempcompname(const void *a, const void *b) {
    return(strcmp((char *)a, ((st_ptr *)b)->name));
}


/*
 * seeking function: looks for a value in a shortcut table
 * (tempVar, tempZone, tempTable)
 */
void *tempsearch(const void *elem, const void *base, size_t nbelem,
                 size_t size, int (*comparefunc)(const void *, const void *),
                 size_t *nb) {
    void *ptr;
    int pos;


    *nb = 0;
    ptr = bsearch(elem, base, nbelem, size, comparefunc);
    if (!ptr)
        return(NULL);
    pos = ((char *)ptr - (char *)base) / size;
    /* go back to first entry of the sorted table */
    while (pos > 0
            && comparefunc(elem, (void *)((char *)base + (pos - 1 ) *size)) == 0)
        pos--;
    /* computes number of entries in the table */
    while (pos + *nb < nbelem
            && comparefunc(elem, (void *)((char *)base + (pos + *nb) * size)) == 0)
        (*nb)++;

    return((void *)(((char *)base) + pos * size));
}


char *includefile(char *path, int *filesize) {
    FILE *f;
    char *buf;


    if ((f = fopen(path, "r")) == NULL) {
        return(NULL);
    }

    fseek(f, 0, SEEK_END);
    *filesize = ftell(f);
    rewind(f);
    buf = (char *)malloc(*filesize);
    if (!buf) {
        fclose(f);
        return(NULL);
    }
    fread(buf, 1, *filesize, f);
    fclose(f);

    return(buf);
}


#ifdef _USE_FETCH_
/*
 * you'd better be sure there's no buffer overflow possible with this
 * library before using this feature...
 */
Template *templateSetFileURL(Template **tmplte, char *filename) {
    FILE *f;
    char *ptr;
    int pos, size, start;
    char *tempBuf;
    int tempstart;
    char tmp[VARSZ + 1], name[VARSZ + 1];
    int i;
    int nbvar;
    int type;
    tempUnit *Unit;
    struct url_stat stat;
    char *filebuf;
    int filesize;


#ifdef DEBUG

    fprintf(stderr, "templateSetFileURL: %s\n", filename);
    fflush(stderr);
#endif

    if ((f = fetchXGetURL(filename, &stat, "")) == NULL) {
#ifdef DEBUG
        fprintf(stderr, "*** error fetching file\n");
        fflush(stderr);
#endif

        return(NULL);
    }

    templateFreeMem(*tmplte);
    *tmplte = (Template *)malloc(sizeof(Template));
    memset(*tmplte, 0, sizeof(Template));
    size = stat.size;
    tempBuf = (char *)malloc(sizeof(char) * (size + 1));
    tempBuf[size] = '\0';
    fread(tempBuf, 1, size, f);
    fclose(f);

    (*tmplte)->tempBuf = tempBuf;
    (*tmplte)->tempnbVar = (*tmplte)->tempnbZone
                           = (*tmplte)->tempnbTable = 0;
    (*tmplte)->tempVar = (*tmplte)->tempZone = (*tmplte)->tempTable = NULL;
    (*tmplte)->UnitInit = (tempUnit *)malloc(sizeof(tempUnit));
    memset((*tmplte)->UnitInit, 0, sizeof(tempUnit));
    Unit = (*tmplte)->UnitInit;
    nbvar = 0;
    tempstart = 0;
    start = pos = 0;
    while (pos < size) {
        if (tempBuf[pos] == '#') {
            if (tempBuf[pos + 1] == '#') {
                /* the encountered code till there is pure html */
                memmove(tempBuf + tempstart, tempBuf + start,
                        pos - start);
                i = 0;
                Unit->next = (tempUnit *)malloc(sizeof(tempUnit));
                memset(Unit->next, 0, sizeof(tempUnit));
                Unit->next->prev = Unit;
                Unit->data = tempBuf + tempstart;
                Unit->tdata = pos - start;
                Unit->type = TEMP_HTML;
                Unit = Unit->next;
                tempstart += pos - start;

                /* from now on we're in the variable name */
                pos += 2;
                while (pos + i < size
                        && tempBuf[pos + i] != '#'
                        && i < VARSZ)
                    i++;
                memcpy(tmp, tempBuf + pos, i);
                tmp[i] = '\0';

                /* saves the unit containing the variable */
                Unit->next = (tempUnit *)malloc(sizeof(tempUnit));
                memset(Unit->next, 0, sizeof(tempUnit));
                Unit->next->prev = Unit;
                Unit->type = TEMP_VAR;
                Unit->name = strdup(tmp);
                /* adds the variable in the shortcut table */
                (*tmplte)->tempVar =
                    (st_ptr *)realloc((*tmplte)->tempVar,
                                      sizeof(st_ptr) * ((*tmplte)->tempnbVar + 1));
                (*tmplte)->tempVar[(*tmplte)->tempnbVar].name = strdup(tmp);
                (*tmplte)->tempVar[(*tmplte)->tempnbVar].unit = Unit;
                (*tmplte)->tempnbVar++;

                Unit = Unit->next;
                nbvar++;
                pos += i + 1;
                start = pos + 1;
            }
        }
        /* comments */
        else if (tempBuf[pos] == '<'
                 && tempBuf[pos + 1] == '!'
                 && tempBuf[pos + 2] == '-'
                 && tempBuf[pos + 3] == '-') {
            /* the encountered code till there is pure html */
            memmove(tempBuf + tempstart, tempBuf + start, pos - start);
            i = 0;
            Unit->next = (tempUnit *)malloc(sizeof(tempUnit));
            memset(Unit->next, 0, sizeof(tempUnit));
            Unit->next->prev = Unit;
            Unit->data = tempBuf + tempstart;
            Unit->tdata = pos - start;
            Unit->type = TEMP_HTML;
            Unit = Unit->next;
            tempstart += pos - start;
            start = pos;

            pos += 4;
            i = 0;
            while (isspace(tempBuf[pos]))
                pos ++;
            while (pos < size
                    && tempBuf[pos] != '-'
                    && tempBuf[pos] != '>'
                    && !isspace(tempBuf[pos])
                    && i < VARSZ) {
                tmp[i++] = tempBuf[pos];
                pos++;
            }
            tmp[i] = '\0';
            while (isspace(tempBuf[pos]))
                pos++;
            i = 0;
            while (pos < size
                    && tempBuf[pos] != '-'
                    && tempBuf[pos] != '>'
                    && !isspace(tempBuf[pos])
                    && i < VARSZ) {
                name[i++] = tempBuf[pos];
                pos++;
            }
            name[i] = '\0';
            while (pos < size && tempBuf[pos] != '>')
                pos++;

            type = -1;
            if (strcmp(tmp, "#INCLUDEFILE") == 0) {
                type = TEMP_INCLUDEFILE;
                filebuf = includefile(name, &filesize);
                if (filebuf) {
                    pos++;
                    size += filesize - (pos - start);
                    tempBuf = (char *)realloc(tempBuf, size);
                    memmove(tempBuf + start + filesize, tempBuf + pos, size + 1 - pos);
                    memcpy(tempBuf + start, filebuf, filesize);
                    free(filebuf);
                    continue;
                }
            } else if (strcmp(tmp, "#BEGINTABLE") == 0)
                type = TEMP_BEGINTABLE;
            else if (strcmp(tmp, "#ENDTABLE") == 0)
                type = TEMP_ENDTABLE;
            else if (strcmp(tmp, "#BEGINZONE") == 0)
                type = TEMP_BEGINZONE;
            else if (strcmp(tmp, "#ENDZONE") == 0)
                type = TEMP_ENDZONE;

            if (type != -1) {
                /* saves the unit containing the variable */
                Unit->next = (tempUnit *)malloc(sizeof(tempUnit));
                memset(Unit->next, 0, sizeof(tempUnit));
                Unit->type = type;
                Unit->next->prev = Unit;
                if (Unit->type != TEMP_HTML)
                    Unit->name = strdup(name);
                switch (type) {
                case TEMP_BEGINTABLE:
                    (*tmplte)->tempTable
                    = (st_ptr *)realloc((*tmplte)->tempTable,
                                        sizeof(st_ptr)
                                        * ((*tmplte)->tempnbTable + 1));
                    (*tmplte)->tempTable[(*tmplte)->tempnbTable].name = strdup(name);
                    (*tmplte)->tempTable[(*tmplte)->tempnbTable].unit = Unit;
                    (*tmplte)->tempnbTable++;
                    break;
                case TEMP_BEGINZONE:
                    (*tmplte)->tempZone
                    = (st_ptr *)realloc((*tmplte)->tempZone,
                                        sizeof(st_ptr)
                                        * ((*tmplte)->tempnbZone + 1));
                    (*tmplte)->tempZone[(*tmplte)->tempnbZone].name = strdup(name);
                    (*tmplte)->tempZone[(*tmplte)->tempnbZone].unit = Unit;
                    (*tmplte)->tempnbZone++;
                    break;
                }
                Unit = Unit->next;
            } else {
                /* the whole unit is taken for html */
                memmove(tempBuf + tempstart, tempBuf + start, pos + 1 - start);
                Unit->next = (tempUnit *)malloc(sizeof(tempUnit));
                memset(Unit->next, 0, sizeof(tempUnit));
                Unit->next->prev = Unit;
                Unit->data = tempBuf + tempstart;
                Unit->tdata = pos + 1 - start;
                Unit->type = TEMP_HTML;
                Unit = Unit->next;
                tempstart += pos + 1 - start;
            }
            start = pos + 1;
        }
        pos++;
    }
    if (tempstart < size) {
        memmove(tempBuf + tempstart, tempBuf + start, pos - start);
        Unit->next = NULL;
        Unit->data = tempBuf + tempstart;
        Unit->tdata = pos - start;
        Unit->type = TEMP_HTML;
        tempstart += pos - start;
    }

    free(tempBuf);
    qsort((*tmplte)->tempVar, (*tmplte)->tempnbVar, sizeof(st_ptr),
          tempcompare);
    qsort((*tmplte)->tempZone, (*tmplte)->tempnbZone, sizeof(st_ptr),
          tempcompare);
    qsort((*tmplte)->tempTable, (*tmplte)->tempnbTable, sizeof(st_ptr),
          tempcompare);

    return(*tmplte);
}
#endif



Template *templateSetFile(Template **tmplte, char *filename) {
    FILE *f;
    int pos, size, start;
    char *tempBuf;
    int tempstart;
    char tmp[VARSZ + 1], name[VARSZ + 1];
    int i;
    int nbvar;
    int type;
    tempUnit *Unit;
    char *filebuf;
    int filesize;



#ifdef DEBUG

    fprintf(stderr, "templateSetFile: %s\n", filename);


    fflush(stderr);
#endif

    if ((f = fopen(filename, "r")) == NULL) {
#ifdef DEBUG
        fprintf(stderr, "*** error opening file\n");
        fflush(stderr);
#endif

        return(NULL);
    }

    templateFreeMem(*tmplte);
    *tmplte = (Template *)malloc(sizeof(Template));
    memset(*tmplte, 0, sizeof(Template));
    fseek(f, 0, SEEK_END);
    size = ftell(f);
    rewind(f);
    tempBuf = (char *)malloc(sizeof(char) * (size + 1));
    tempBuf[size] = '\0';
    fread(tempBuf, 1, size, f);
    fclose(f);

    (*tmplte)->tempnbVar = (*tmplte)->tempnbZone
                           = (*tmplte)->tempnbTable = 0;
    (*tmplte)->tempVar = (*tmplte)->tempZone = (*tmplte)->tempTable = NULL;
    (*tmplte)->UnitInit = (tempUnit *)malloc(sizeof(tempUnit));
    memset((*tmplte)->UnitInit, 0, sizeof(tempUnit));
    Unit = (*tmplte)->UnitInit;
    nbvar = 0;
    tempstart = 0;
    start = pos = 0;
    while (pos < size) {
        if (tempBuf[pos] == '#') {
            if (tempBuf[pos + 1] == '#') {
                /* the encountered code till there is pure html */
                memmove(tempBuf + tempstart, tempBuf + start,
                       pos - start);
                i = 0;
                Unit->next = (tempUnit *)malloc(sizeof(tempUnit));
                memset(Unit->next, 0, sizeof(tempUnit));
                Unit->next->prev = Unit;
                Unit->data = tempBuf + tempstart;
                Unit->tdata = pos - start;
                Unit->type = TEMP_HTML;
                Unit = Unit->next;
                tempstart += pos - start;

                /* from now on we're in the variable name */
                pos += 2;
                while (pos + i < size
                        && tempBuf[pos + i] != '#'
                        && i < VARSZ)
                    i++;
                memcpy(tmp, tempBuf + pos, i);
                tmp[i] = '\0';

                /* saves the unit containing the variable */
                Unit->next = (tempUnit *)malloc(sizeof(tempUnit));
                memset(Unit->next, 0, sizeof(tempUnit));
                Unit->next->prev = Unit;
                Unit->type = TEMP_VAR;
                Unit->name = strdup(tmp);
                /* adds the variable in the shortcut table */
                (*tmplte)->tempVar =
                    (st_ptr *)realloc((*tmplte)->tempVar,
                                      sizeof(st_ptr) * ((*tmplte)->tempnbVar + 1));
                (*tmplte)->tempVar[(*tmplte)->tempnbVar].name = strdup(tmp);
                (*tmplte)->tempVar[(*tmplte)->tempnbVar].unit = Unit;
                (*tmplte)->tempnbVar++;

                Unit = Unit->next;
                nbvar++;
                pos += i + 1;
                start = pos + 1;
            }
        }
        /* comments */
        else if (tempBuf[pos] == '<'
                 && tempBuf[pos + 1] == '!'
                 && tempBuf[pos + 2] == '-'
                 && tempBuf[pos + 3] == '-') {
            /* the encountered code till there is pure html */
            memmove(tempBuf + tempstart, tempBuf + start, pos - start);
            i = 0;
            Unit->next = (tempUnit *)malloc(sizeof(tempUnit));
            memset(Unit->next, 0, sizeof(tempUnit));
            Unit->next->prev = Unit;
            Unit->data = tempBuf + tempstart;
            Unit->tdata = pos - start;
            Unit->type = TEMP_HTML;
            Unit = Unit->next;
            tempstart += pos - start;
            start = pos;

            pos += 4;
            i = 0;
            while (isspace(tempBuf[pos]))
                pos ++;
            while (pos < size
                    && tempBuf[pos] != '-'
                    && tempBuf[pos] != '>'
                    && !isspace(tempBuf[pos])
                    && i < VARSZ) {
                tmp[i++] = tempBuf[pos];
                pos++;
            }
            tmp[i] = '\0';
            while (isspace(tempBuf[pos]))
                pos++;
            i = 0;
            while (pos < size
                    && tempBuf[pos] != '-'
                    && tempBuf[pos] != '>'
                    && !isspace(tempBuf[pos])
                    && i < VARSZ) {
                name[i++] = tempBuf[pos];
                pos++;
            }
            name[i] = '\0';
            while (pos < size && tempBuf[pos] != '>')
                pos++;

            type = -1;
            if (strcmp(tmp, "#INCLUDEFILE") == 0) {
                type = TEMP_INCLUDEFILE;
                filebuf = includefile(name, &filesize);
                if (filebuf) {
                    pos++;
                    size += filesize - (pos - start);
                    tempBuf = (char *)realloc(tempBuf, size);
                    memmove(tempBuf + start + filesize, tempBuf + pos, size + 1 - pos);
                    memcpy(tempBuf + start, filebuf, filesize);
                    free(filebuf);
                    continue;
                }
            } else if (strcmp(tmp, "#BEGINTABLE") == 0)
                type = TEMP_BEGINTABLE;
            else if (strcmp(tmp, "#ENDTABLE") == 0)
                type = TEMP_ENDTABLE;
            else if (strcmp(tmp, "#BEGINZONE") == 0)
                type = TEMP_BEGINZONE;
            else if (strcmp(tmp, "#ENDZONE") == 0)
                type = TEMP_ENDZONE;

            if (type != -1) {
                /* saves the unit containing the variable */
                Unit->next = (tempUnit *)malloc(sizeof(tempUnit));
                memset(Unit->next, 0, sizeof(tempUnit));
                Unit->type = type;
                Unit->next->prev = Unit;
                if (Unit->type != TEMP_HTML)
                    Unit->name = strdup(name);
                switch (type) {
                case TEMP_BEGINTABLE:
                    (*tmplte)->tempTable
                    = (st_ptr *)realloc((*tmplte)->tempTable,
                                        sizeof(st_ptr)
                                        * ((*tmplte)->tempnbTable + 1));
                    (*tmplte)->tempTable[(*tmplte)->tempnbTable].name = strdup(name);
                    (*tmplte)->tempTable[(*tmplte)->tempnbTable].unit = Unit;
                    (*tmplte)->tempnbTable++;
                    break;
                case TEMP_BEGINZONE:
                    (*tmplte)->tempZone
                    = (st_ptr *)realloc((*tmplte)->tempZone,
                                        sizeof(st_ptr)
                                        * ((*tmplte)->tempnbZone + 1));
                    (*tmplte)->tempZone[(*tmplte)->tempnbZone].name = strdup(name);
                    (*tmplte)->tempZone[(*tmplte)->tempnbZone].unit = Unit;
                    (*tmplte)->tempnbZone++;
                    break;
                }
                Unit = Unit->next;
            } else {
                /* the whole unit is taken for html */
                memmove(tempBuf + tempstart, tempBuf + start, pos + 1 - start);
                Unit->next = (tempUnit *)malloc(sizeof(tempUnit));
                memset(Unit->next, 0, sizeof(tempUnit));
                Unit->next->prev = Unit;
                Unit->data = tempBuf + tempstart;
                Unit->tdata = pos + 1 - start;
                Unit->type = TEMP_HTML;
                Unit = Unit->next;
                tempstart += pos + 1 - start;
            }
            start = pos + 1;
        }
        pos++;
    }
    if (tempstart < size) {
        memmove(tempBuf + tempstart, tempBuf + start, pos - start);
        Unit->next = NULL;
        Unit->data = tempBuf + tempstart;
        Unit->tdata = pos - start;
        Unit->type = TEMP_HTML;
        tempstart += pos - start;
    }

    // free(tempBuf);
    qsort((*tmplte)->tempVar, (*tmplte)->tempnbVar, sizeof(st_ptr),
          tempcompare);
    qsort((*tmplte)->tempZone, (*tmplte)->tempnbZone, sizeof(st_ptr),
          tempcompare);
    qsort((*tmplte)->tempTable, (*tmplte)->tempnbTable, sizeof(st_ptr),
          tempcompare);

    return(*tmplte);
}


void templateSetVar(Template *tmplte, char *fld, char *val) {
    tempUnit *Unit;
    st_ptr *rec;
    size_t i, nb;


    if (val == NULL)
        return;
    rec = (st_ptr *)tempsearch(fld, tmplte->tempVar, tmplte->tempnbVar,
                               sizeof(st_ptr), tempcompname, &nb);
    if (rec) {
        for (i = 0; i < nb; i++) {
            Unit = rec[i].unit;
            if (Unit->data)
                free(Unit->data);
            Unit->data = strdup(val);
            Unit->tdata = strlen(val);
            Unit->alloc = 1;
        }
    }

    rec = (st_ptr *)tempsearch(fld, tmplte->tempZone, tmplte->tempnbZone,
                               sizeof(st_ptr), tempcompname, &nb);
    if (rec) {
        for (i = 0; i < nb; i++) {
            Unit = rec[i].unit;
            Unit->tdata = 1;
        }
    }
}


void templateDumpUnit(tempUnit *UnitP, tempUnit *Unit) {
    tempUnit *UnitN;


    if (!(Unit->type == TEMP_HTML || Unit->type == TEMP_VAR)
            || Unit->type == TEMP_VAR && Unit->data == NULL)
        return;

    UnitN = (tempUnit *)malloc(sizeof(tempUnit));
    memset(UnitN, 0, sizeof(tempUnit));
    UnitN->data = (char *)malloc(Unit->tdata);
    memcpy(UnitN->data, Unit->data, Unit->tdata);
    UnitN->tdata = Unit->tdata;
    UnitN->alloc = 1;
    UnitN->type = TEMP_HTML;
    UnitN->prev = UnitP->prev;
    if (UnitP->prev)
        UnitP->prev->next = UnitN;
    UnitN->next = UnitP;
    UnitP->prev = UnitN;
}


void templateDumpTableLine(Template *tmplte, char *ligne) {
    tempUnit *Unit, *UnitS;
    tempUnit *UnitTableS = NULL, *UnitN, *UnitO, *UnitD;
    int pr;
    size_t i, nb;
    st_ptr *rec;


    rec = (st_ptr *)tempsearch(ligne, tmplte->tempTable, tmplte->tempnbTable,
                               sizeof(st_ptr), tempcompname, &nb);
    if (rec) {
        pr = 1;

        for (i = 0; i < nb; i++) {
            Unit = rec[i].unit;

            /*
             * insert a mark "beginning of generated code"
             */
            UnitN = (tempUnit *)malloc(sizeof(tempUnit));
            memset(UnitN, 0, sizeof(tempUnit));
            UnitN->next = Unit;
            UnitN->prev = Unit->prev;
            Unit->prev->next = UnitN;
            Unit->prev = UnitN;
            UnitN->type = TEMP_BEGINGENTABLE;

            UnitS = Unit;
            Unit = Unit->next;

            /*
             * we go through all the units till the corresponding ENDTABLE
             */
            while (Unit
                    && !(Unit->type == TEMP_ENDTABLE
                         && strcmp(Unit->name, ligne) == 0)) {
                if (Unit->type == TEMP_BEGINGENTABLE) {
                    UnitTableS = Unit;
                } else if (Unit->type == TEMP_ENDGENTABLE) {
                    /*
                     * frees the encountered generated unit
                     */
                    UnitD = UnitTableS->prev;
                    UnitD->next = Unit->next;
                    Unit->next->prev = UnitD;
                    UnitN = UnitTableS;
                    while (UnitN != Unit) {
                        /* freeing the units */
                        if (UnitN->name)
                            free(UnitN->name);
                        if (UnitN->alloc && UnitN->data)
                            free(UnitN->data);
                        UnitO = UnitN;
                        UnitN = UnitN->next;
                        free(UnitO);
                    }
                    /* and we also have to free the ENDGENTABLE unit */
                    free(UnitN);
                    Unit = UnitD;
                } else if (Unit->type == TEMP_BEGINZONE
                           && !tmplte->curzone
                           && Unit->tdata != 1) {
                    free(tmplte->curzone);
                    tmplte->curzone = strdup(Unit->name);
                    pr = 0;
                } else if (Unit->type == TEMP_ENDZONE
                           && tmplte->curzone
                           && strcmp(Unit->name, tmplte->curzone) == 0) {
                    pr = 1;
                    free(tmplte->curzone);
                    tmplte->curzone = NULL;
                } else if (Unit->type == TEMP_BEGINTABLE) {
                    tmplte->curtable = strdup(Unit->name);
                    Unit = Unit->next;
                    while (Unit
                            && !(Unit->type == TEMP_ENDTABLE
                                 && strcmp(Unit->name, tmplte->curtable) == 0)) {
                        Unit = Unit->next;
                    }
                    free(tmplte->curtable);
                    tmplte->curtable = NULL;
                } else {
                    if (pr) {
                        templateDumpUnit(UnitS, Unit);
                    }
                    /*
                     * if the unit is a variable, reinitialize it once copied
                     */
                    if (Unit->type == TEMP_VAR) {
                        free(Unit->data);
                        Unit->data = NULL;
                        Unit->tdata = 0;
                        Unit->alloc = 0;
                    } else if (Unit->type == TEMP_BEGINZONE) {
                        Unit->tdata = 0;
                    }
                }
                if (Unit)
                    Unit = Unit->next;
            }
            /*
             * insert a mark "end of generated code"
             */
            UnitO = rec[i].unit;
            UnitN = (tempUnit *)malloc(sizeof(tempUnit));
            memset(UnitN, 0, sizeof(tempUnit));
            UnitN->next = UnitO;
            UnitN->prev = UnitO->prev;
            UnitO->prev->next = UnitN;
            UnitO->prev = UnitN;
            UnitN->type = TEMP_ENDGENTABLE;
        }
    }
}


void templatePrint(Template *tmplte) {
    tempUnit *Unit;
    char *ptr;
    int pr;


    Unit = tmplte->UnitInit;
    pr = 1;
    while (Unit) {
        if (Unit->type == TEMP_BEGINTABLE) {
            tmplte->curtable = strdup(Unit->name);
            Unit = Unit->next;
            while (Unit
                    && !(Unit->type == TEMP_ENDTABLE
                         && strcmp(Unit->name, tmplte->curtable) == 0)) {
                Unit = Unit->next;
            }
            free(tmplte->curtable);
            tmplte->curtable = NULL;
        } else if (Unit->type == TEMP_BEGINZONE && !tmplte->curzone
                   && Unit->tdata != 1) {
            pr = 0;
            free(tmplte->curzone);
            tmplte->curzone = strdup(Unit->name);
        } else if (Unit->type == TEMP_ENDZONE
                   && tmplte->curzone
                   && strcmp(Unit->name, tmplte->curzone) == 0) {
            pr = 1;
            free(tmplte->curzone);
            tmplte->curzone = NULL;
        } else if (pr && (Unit->type == TEMP_HTML || Unit->type == TEMP_VAR)
                   && Unit->data) {
            ptr = (char *)malloc(Unit->tdata + 1);
            memcpy(ptr, Unit->data, Unit->tdata);
            ptr[Unit->tdata] = '\0';
            fputs(ptr, stdout);
            free(ptr);
        }
        if (Unit)
            Unit = Unit->next;
    }
}


char *templatePage(Template *tmplte) {
    char *tBufp;
    int sizep = 0;

    tempUnit *Unit;
    int pr;


    tBufp = NULL;
    Unit = tmplte->UnitInit;
    pr = 1;
    while (Unit) {
        if (Unit->type == TEMP_BEGINTABLE) {
            tmplte->curtable = strdup(Unit->name);
            Unit = Unit->next;
            while (Unit
                    && !(Unit->type == TEMP_ENDTABLE
                         && strcmp(Unit->name, tmplte->curtable) == 0)) {
                Unit = Unit->next;
            }
            free(tmplte->curtable);
            tmplte->curtable = NULL;
        } else if (Unit->type == TEMP_BEGINZONE && !tmplte->curzone
                   && Unit->tdata != 1) {
            pr = 0;
            free(tmplte->curzone);
            tmplte->curzone = strdup(Unit->name);
        } else if (Unit->type == TEMP_ENDZONE
                   && tmplte->curzone
                   && strcmp(Unit->name, tmplte->curzone) == 0) {
            pr = 1;
            free(tmplte->curzone);
            tmplte->curzone = NULL;
        } else if (pr && (Unit->type == TEMP_HTML || Unit->type == TEMP_VAR)
                   && Unit->data) {
            tBufp = (char *)realloc(tBufp, sizep + Unit->tdata + 1);
            memcpy(tBufp + sizep, Unit->data, Unit->tdata);
            tBufp[sizep + Unit->tdata] = '\0';
            sizep += Unit->tdata;
        }
        if (Unit)
            Unit = Unit->next;
    }
    return(tBufp);
}


void templateFreeMem(Template *tmplte) {
    tempUnit *Unit, *UnitO;
    int i;


    if (!tmplte)
        return;
    Unit = tmplte->UnitInit;
    while (Unit) {
        if (Unit->name)
            free(Unit->name);
        if (Unit->alloc && Unit->data)
            free(Unit->data);
        UnitO = Unit;
        Unit = Unit->next;
        free(UnitO);
    }
    tmplte->UnitInit = NULL;
    for (i = 0; i < tmplte->tempnbVar; i++)
        free(tmplte->tempVar[i].name);
    for (i = 0; i < tmplte->tempnbZone; i++)
        free(tmplte->tempZone[i].name);
    for (i = 0; i < tmplte->tempnbTable; i++)
        free(tmplte->tempTable[i].name);
    if (tmplte->tempVar) {
        free(tmplte->tempVar);
        tmplte->tempVar = NULL;
    }
    if (tmplte->tempZone) {
        free(tmplte->tempZone);
        tmplte->tempZone = NULL;
    }
    if (tmplte->tempTable) {
        free(tmplte->tempTable);
        tmplte->tempTable = NULL;
    }
    tmplte->tempnbVar = tmplte->tempnbZone = tmplte->tempnbTable = 0;

    if (tmplte->curzone) {
        free(tmplte->curzone);
        tmplte->curzone = NULL;
    }
    if (tmplte->curtable) {
        free(tmplte->curtable);
        tmplte->curtable = NULL;
    }
    if (tmplte->tempBuf) {
        free(tmplte->tempBuf);
        tmplte->tempBuf = NULL;
    }
    free(tmplte);
}
